/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.whatif;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class WhatIfBound {
    private final double bound;
    private final double step;
    private final BoundMode mode;
    private final BoundType type;

    public WhatIfBound(double bound, double step, @Nonnull BoundMode mode, @Nonnull BoundType type) {
        this.mode = Preconditions.checkNotNull(mode);
        this.type = Preconditions.checkNotNull(type);
        if (mode == BoundMode.RELATIVE) {
            if (type == BoundType.LOWER) {
                Preconditions.checkArgument(bound <= 1.0);
            } else {
                Preconditions.checkArgument(bound >= 1.0);
            }
        }
        this.bound = bound;
        this.step = step > 0.0 ? step : Double.NaN;
    }

    public double getBound() {
        return this.bound;
    }

    public double getStep() {
        return this.step;
    }

    @Nonnull
    public BoundMode getMode() {
        return this.mode;
    }

    @Nonnull
    public BoundType getType() {
        return this.type;
    }

    public int getSign() {
        return this.type == BoundType.UPPER ? 1 : -1;
    }

    public long getAbsoluteValue(long originalValue, double relativeValue) throws IllegalArgumentException {
        Preconditions.checkArgument(relativeValue >= 0.0 && relativeValue <= 1.0);
        long absBound = this.mode == BoundMode.ABSOLUTE ? (long)this.bound : (long)((double)originalValue * this.bound);
        long dif = (long)((double)(absBound - originalValue) * relativeValue);
        long res = originalValue + dif;
        return this.getStepCorrectValue(originalValue, res);
    }

    public long getStepCorrectValue(long originalValue, long newValue) {
        if (this.type == BoundType.LOWER) {
            Preconditions.checkArgument(originalValue >= newValue);
        } else {
            Preconditions.checkArgument(originalValue <= newValue);
        }
        if (Double.isNaN(this.step)) {
            return newValue;
        }
        long s2 = this.getAbsoluteStep(originalValue);
        long rem = (newValue - originalValue) % s2;
        if (rem == 0L) {
            return newValue;
        }
        long div = (newValue - originalValue) / s2;
        if (this.type == BoundType.LOWER) {
            return Math.max(originalValue + (div - 1L) * s2, this.getAbsoluteBound(originalValue));
        }
        if (this.type == BoundType.UPPER) {
            return Math.min(originalValue + (div + 1L) * s2, this.getAbsoluteBound(originalValue));
        }
        throw new IllegalStateException();
    }

    public long getAbsoluteBound(long originalValue) {
        if (this.mode == BoundMode.ABSOLUTE) {
            return (long)this.bound;
        }
        return (long)(this.bound * (double)originalValue);
    }

    public double getRelativeBound(long originalValue) {
        if (this.mode == BoundMode.RELATIVE) {
            return this.bound;
        }
        if ((long)this.bound == originalValue) {
            return 1.0;
        }
        return this.bound / (double)originalValue;
    }

    public long getAbsoluteStep(long originalValue) throws IllegalStateException {
        Preconditions.checkState(!Double.isNaN(this.step));
        if (this.mode == BoundMode.ABSOLUTE) {
            return (long)this.step;
        }
        return (long)(this.step * (double)originalValue);
    }

    public double getRelativeStep(long originalValue) {
        if (this.mode == BoundMode.RELATIVE) {
            return this.step;
        }
        return this.step / (double)originalValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bound", this.bound).add("step", this.step).add("mode", (Object)this.mode).add("type", (Object)this.type).toString();
    }

    public static enum BoundMode {
        ABSOLUTE,
        RELATIVE;

    }

    public static enum BoundType {
        LOWER,
        UPPER;

    }
}

